from asyncio import sleep
import imp
from importlib.util import module_for_loader
from webbrowser import get
from xmlrpc.client import FastMarshaller
# from fleming.hta.exc_psf_alpha_control import myalpha_on
from fleming.hta.fleming_measurement import *
from fleming.hta.hw_control import *
from fleming.hta.AxisScan import AxisScan, Scan
from fleming.hta.scantable_location import scantable_location, scantable_96plate_location, scantable_384plate_location
import math

import config_enum.scan_table_enum as scan_table_enum
import config_enum.detector_aperture_slider_enum as das_enum
from fleming.hta.exc_psf_alpha_control import *

from fleming.hta.newton import prediction
from fleming.hta.static_functions import *

# fleming.hta.fleming_measurement_test.trf_flashlamp_batch
async def trf_flashlamp_batch(repeat=2,prefuncs_post=[],funcs_pre=[],comment=""):
    timestamp=True
    ## TRF laser
    # await trf_go()
    cmt="trf_flash_apclosed"+comment
    prefuncs=[[trf_flashlamp_init],[fm.Move,12],[apertures,0,0],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    # prefuncs=[[fm.Move,12],[apertures,0,0],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    prefuncs=prefuncs+prefuncs_post
    funcs=[[kaleido_trf_flashlamp,100,50,400,1],[pmt1_temperature],[pmt2_temperature]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
    funcs=funcs_pre+funcs
    postfuncs=[]  # -1:1.6; 0: close; 1:3
    # 1/250*0.4*1e-3=10 s
    # funcs=[[kaleido_trf_laser,10000,50,400,1,0],[pmt1_temperature],[pmt2_temperature]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)

    # cmt="trf_flash_ap3"+comment
    # prefuncs=[[trf_flashlamp_init],[fm.Move,12],[apertures,1,1],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    # prefuncs=prefuncs+prefuncs_post
    # fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    # await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)

    

# fleming.hta.fleming_measurement.batch
async def trf_batch(repeat=2,prefuncs_post=[],funcs_pre=[],comment=""):
    timestamp=True
    ## TRF laser
    # await trf_go()
    cmt="trf_meas_apclosed"+comment
    prefuncs=[[trf_laser_init],[fm.Move,12],[apertures,0,0],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    prefuncs=prefuncs+prefuncs_post
    funcs=[[kaleido_trf_laser,100,50,400,1,0],[pmt1_temperature],[pmt2_temperature]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
    funcs=funcs_pre+funcs
    postfuncs=[]  # -1:1.6; 0: close; 1:3
    # 1/250*0.4*1e-3=10 s
    # funcs=[[kaleido_trf_laser,10000,50,400,1,0],[pmt1_temperature],[pmt2_temperature]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)

    cmt="trf_meas_ap3"+comment
    prefuncs=[[trf_laser_init],[fm.Move,12],[apertures,1,1],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    prefuncs=prefuncs+prefuncs_post
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)

    

# fleming.hta.fleming_measurement.lum_batch
async def lum_batch(repeat=2,prefuncs_post=[],funcs_pre=[],comment=""):
    timestamp=True
    
    cmt="lum_alphamodule_apclose"+comment
    # prefuncs=[[lum_init],[fm.Move,12],[apertures,0,0],[set_hv, 0.5,0.5],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    prefuncs=[[lum_init],[fm.Move,12],[apertures,0,0],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    prefuncs=prefuncs+prefuncs_post
    funcs=[[kaleido_lum,1000],[pmt1_temperature],[pmt2_temperature]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
    funcs=funcs_pre+funcs
    postfuncs=[]  # -1:1.6; 0: close; 1:3
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)

    cmt="lum_alphamodule_ap30"+comment
    prefuncs=[[lum_init],[fm.Move,12],[apertures,1,1],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    prefuncs=prefuncs+prefuncs_post
    funcs=[[kaleido_lum,1000],[pmt1_temperature],[pmt2_temperature]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
    funcs=funcs_pre+funcs
    postfuncs=[]  # -1:1.6; 0: close; 1:3
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)

async def alpha_batch(repeat=2,prefuncs_post=[],funcs_pre=[],comment=""):
    timestamp=True
    
    cmt="alpha_apclose"+comment
    prefuncs=[[alpha_init],[fm.Move,12],[apertures,0,0],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    prefuncs=prefuncs+prefuncs_post
    funcs=[[kaleido_alpha,0.38, 180,1000],[pmt1_temperature],[pmt2_temperature]] # exc_power=0.38, exc_time_ms = 180, det_time_ms = 370, pause_ms=1, ref_window_ms = 5):
    funcs=funcs_pre+funcs
    postfuncs=[]  # -1:1.6; 0: close; 1:3
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)

    cmt="alpha_ap30"+comment
    prefuncs=[[alpha_init],[fm.Move,12],[apertures,1,1],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    prefuncs=prefuncs+prefuncs_post
    funcs=[[kaleido_alpha,0.38, 180,1000],[pmt1_temperature],[pmt2_temperature]] # exc_power=0.38, exc_time_ms = 180, det_time_ms = 370, pause_ms=1, ref_window_ms = 5):
    funcs=funcs_pre+funcs
    postfuncs=[]  # -1:1.6; 0: close; 1:3
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)

async def fi_batch(repeat=2,prefuncs_post=[],funcs_pre=[],comment=""):
    timestamp=True
    
    cmt="fi_apclose"+comment
    prefuncs=[[FI_init],[fm.Move,12],[apertures,0,0],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    prefuncs=prefuncs+prefuncs_post
    funcs=[[kaleido_FI,0.1],[pmt1_temperature],[pmt2_temperature]] # exc_power=0.38, exc_time_ms = 180, det_time_ms = 370, pause_ms=1, ref_window_ms = 5):
    funcs=funcs_pre+funcs
    postfuncs=[]  # -1:1.6; 0: close; 1:3
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)

    cmt="fi_ap30"+comment
    prefuncs=[[FI_init],[fm.Move,12],[apertures,1,1],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    prefuncs=prefuncs+prefuncs_post
    funcs=[[kaleido_FI,0.1],[pmt1_temperature],[pmt2_temperature]] # exc_power=0.38, exc_time_ms = 180, det_time_ms = 370, pause_ms=1, ref_window_ms = 5):
    funcs=funcs_pre+funcs
    postfuncs=[]  # -1:1.6; 0: close; 1:3
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)

async def cooling_testing2():
    target=[20,30]
    for t in target:
        await cooling_testing(t)



async def cooling_testing(t=30):
    repeat=500
    # repeat=2;
    timestamp=True
    await darkcount_measurement_init()
    # target=[20]
    cmt="colling_test"
    target=await coolingControl(t)
    
    print(target)
    
    counter=0
    file= fnameGen(cmt+f"target_temperature_{t}",timestamp)
    head=""
    with open(file,'a') as f:
        writer=csv.writer(f, delimiter='\t', dialect='excel-tab')
        writer.writerows([list(target)])
        for i in range(repeat):
            await sleep(1)
            out=await get_all_temp()
            if counter==0:
                head+="\t".join([f"{x}" for x in out.keys()])
                head+="\n"
                f.write("time\t"+head)
                
            output=[k for k in out.values()]
            tstr=datetime.now().strftime("%y.%m.%d.%H.%M.%S.%f")
            
            writer.writerows([list([tstr,*output])])
            print(counter)
            print(output)
            counter+=1

    
    

async def cooling_batch2():
    for i in range(10):
        await cooling_batch()
        
async def cooling_batch():
    repeat=4500
    # repeat=2;
    timestamp=True
    await darkcount_measurement_init()
    # target=[20]
    target=[30,25,20,15]
    for t in target:
    # for t in range(18,31):
        cmt="darkcount_cooling"
        prefuncs=[[apertures,0,0],[set_hv, 0.5,0.5],[get_hv],[coolingControl,t]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
        funcs=[[kaleido_darkcount,1000],[get_all_temp]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
        postfuncs=[]  # -1:1.6; 0: close; 1:3
        fname=fnameGen(f"{instrument}_{cmt}_temp_{t}",timestamp,prefuncs)
        await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)


import math
def get_dew_point_c(t_air_c, rel_humidity):
    """Compute the dew point in degrees Celsius
    :param t_air_c: current ambient temperature in degrees Celsius
    :type t_air_c: float
    :param rel_humidity: relative humidity in %
    :type rel_humidity: float
    :return: the dew point in degrees Celsius
    :rtype: float
    """
    A = 17.27
    B = 237.7
    alpha = ((A * t_air_c) / (B + t_air_c)) + math.log(rel_humidity/100.0)
    return (B * alpha) / (A - alpha)


async def temperature_rt():
    tmp=await get_all_temp()
    temp0=tmp['tmb_rt']
    humidity0=tmp['tmb_hum']
    dew=get_dew_point_c(temp0,humidity0)

    if not hasattr(temperature_rt,"dew"):
        temperature_rt.dew=[dew]*10
        temperature_rt.currentIndex=0
    else:
        temperature_rt.currentIndex+=1
        temperature_rt.dew[temperature_rt.currentIndex%len(temperature_rt.dew)]=dew
            
    return sum(temperature_rt.dew)/len(temperature_rt.dew)

async def temperature_dew():
    diff=2
    target = diff+await temperature_rt()
    return target

async def updateTarget_c():
    t = await temperature_dew()
    await coolingControl(t)
    return [t]

async def cooling_limit_batch():
    repeat=4500*9
    # repeat=2;
    timestamp=True
    await darkcount_measurement_init()
    # target=[20]
    # target=[7]
    # tmp=get_all_temp()
    # current_temperature=tmp['tmb_rt']
    # current_humidity=tmp['tmb_hum']
    # dew=get_dew_point_c(current_temperature,current_humidity)
    
    cmt="darkcount_cooling_limit"
    prefuncs=[[apertures,0,0],[set_hv, 0.5,0.5],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    funcs=[[kaleido_darkcount,1000],[get_all_temp],[updateTarget_c],[sleep, 9]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
    postfuncs=[]  # -1:1.6; 0: close; 1:3
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)



# fleming.hta.fleming_measurement.well_batch
async def well_batch(height=12,comment=""):
    # await scanTable_init()
    st = VUnits.instance.hal.scan_table


    # well
    r=3.6
    n=3
    well_prefuncs=[[scanWell,[r,n],[r,n]]] # # row=[1,2],column=[3,4]):    
    well_funcs=[[scanPlate,"current"],[scanWell],[kaleido_trf_laser,10,50,400,1,0],[get_all_temp]]
    well_repeat=n*n
    cmt="trf_wellScan"
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,well_prefuncs)

    well=[[adaptor,cmt,fname,False,well_prefuncs,well_funcs,well_repeat]]
    
    
    # try to save the prefuncs of the well scan. which contains the paremeters. otherwise, it is working well.
    # plate 
    # row=[1,16]
    # column=[1,24]
    
    row=[1,2]
    column=[3,5]

    plate_repeat=(row[1]-row[0]+1)*(column[1]-column[0]+1)    
    plate_prefuncs=[[scanPlate,row,column],[trf_laser_init],[fm.Move,height],[apertures,1,1],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    
    plate_funcs=[[scanPlate]] + well # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
    postfuncs=[]  # -1:1.6; 0: close; 1:3
    # 1/250*0.4*1e-3=10 s
    # funcs=[[kaleido_trf_laser,10000,50,400,1,0],[pmt1_temperature],[pmt2_temperature]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
    await adaptor(cmt,fname,timestamp,plate_prefuncs,plate_funcs,plate_repeat,postfuncs)
    await st.Move(0,0)


# fleming.hta.fleming_measurement_test.well_trf_lamp_batch
async def well_trf_lamp_batch(height=12,comment=""):
    # await scanTable_init()
    st = VUnits.instance.hal.scan_table
    # well
    r=3.6
    n=9
    well_prefuncs=[[scanWell,[r,n],[r,n]]] # # row=[1,2],column=[3,4]):    
    well_funcs=[[scanPlate,"current"],[scanWell],[kaleido_trf_flashlamp,50,50,400,1,0]] #,[get_all_tmp]]
    well_repeat=n*n
    cmt="trf_wellScan"
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,well_prefuncs)

    well=[[adaptor,cmt,fname,False,well_prefuncs,well_funcs,well_repeat]]

    # try to save the prefuncs of the well scan. which contains the paremeters. otherwise, it is working well.
    # plate 
    # row=[1,16]
    # column=[1,24]
    
    row=[1,16]
    column=[1,24]

    plate_repeat=(row[1]-row[0]+1)*(column[1]-column[0]+1)    
    plate_prefuncs=[[scanPlate,row,column],[trf_flashlamp_init],[fm.Move,height],[apertures,1,1],[get_hv]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    
    plate_funcs=[[scanPlate]] + well # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
    postfuncs=[]  # -1:1.6; 0: close; 1:3
    # 1/250*0.4*1e-3=10 s
    # funcs=[[kaleido_trf_laser,10000,50,400,1,0],[pmt1_temperature],[pmt2_temperature]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
    await adaptor(cmt,fname,timestamp,plate_prefuncs,plate_funcs,plate_repeat,postfuncs)
    await st.Move(0,0)


async def st_move_x(v):
    st = VUnits.instance.hal.scan_table
    x0,y0=st.get_current_position()
    await st.Move(v,y0)

async def st_move_y(v):
    st = VUnits.instance.hal.scan_table
    x0,y0=st.get_current_position()
    await st.Move(x0,v)

# fleming.hta.fleming_measurement_test.psf_measurement
async def psf_measurement(z0=12,comment=""):
    try:
        await myInitialization()
        pass
    except:
        print("error in initialization! skip error and continue!")
        
    st = VUnits.instance.hal.scan_table
    await scanTable_init("'96 Test Plate'")
    await st.MoveToWell(1,1)
    
    # well
    r=5
    n=9
    rz=7
    nz=9
    
    x0,y0 = st.get_current_position()
    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_x,[-r/2+y0,r/2+y0],n)

    zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    
    psfscan=Scan([[xscan],[yscan],[zscan]])
    # psfscan=Scan([[xscan],[yscan]])
    dims=psfscan.dims
    prod=1
    for d in dims:
        prod*=d
    
    # prefuncs=[[trf_flashlamp_init],[fm.Move,height],[apertures,1,1],[get_hv]]
    # psfscan.functions([[psfscan.currentIndex],[kaleido_trf_flashlamp,50,50,400,1,0]])
    # prefuncs=[[lum_init],[fm.Move,height],[apertures,1,1],[get_hv]]
    # fm_barcode=1006, meas_height=15, meas_time=100, num_wells=96, top_meas=False
    prefuncs=[[FI_init,"1002",15,100,96,True],[apertures,1,1],[get_hv]]
    psfscan.functions([[psfscan.currentIndex],[kaleido_FI,0.1]])
    # trf_flashlamp_init(filterModule = 4001, measTime = 100, numberOfWindows = 1, delay_us = 100, windowTime_us = 400)
    # prefuncs=[[trf_flashlamp_init, 4002, 100, 1, 100, 400],[fm.Move,height],[apertures,1,1],[get_hv]]
    # psfscan.functions([[psfscan.currentIndex],[kaleido_trf_flashlamp]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    # prefuncs=[[abs_init,"4002"],[fm.Move,height],[apertures,1,1],[get_hv]]
    # psfscan.functions([[psfscan.currentIndex],[kaleido_abs]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    print(psfscan.dims)
    cmt = "psf_testing"
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)

    with open(fname,'a') as f:
        f.write(f"{comment}:{socket.gethostname()}\n")
        f.write(f"precalled func:")
        writer=csv.writer(f, delimiter=';', dialect='excel-tab')
        h = await psfscan.header(prefuncs)
        f.write(h+"\n")
    
    counter=0
    # actual core functions with or without header
    with open(fname,'a') as f:
        writer=csv.writer(f, delimiter='\t', dialect='excel-tab')
        str=await psfscan.header()
        f.write(str)
        
        for i in range(prod):
            # print(output)
            output=await psfscan.next()
            tstr=datetime.now().strftime("%y.%m.%d.%H.%M.%S.%f")
            writer.writerows([list([tstr,*output])])
            print(counter)
            print(output)
            counter+=1

    # post functions for cleaning up
    # for d in postfuncs:
    #     out = await d[0](*d[1:len(d)])

    print(f"done!:\t{inspect.stack()[0][3]}")



# fleming.hta.fleming_measurement_test.psf_measurement
async def psf_plate_characterization(height=12,comment=""):
    try:
        await myInitialization()
        pass
    except:
        print("error in initialization! skip error and continue!")
        
    st = VUnits.instance.hal.scan_table
    await scanTable_init()
    await st.MoveToWell(1,1)
    x0,y0 = st.get_current_position()

    dp=0.05
    xl=[x0-4.5,x0+4.5*1.5]
    nx=(xl[1]-xl[0])/0.05
    yl=[y0-4.5,y0+4.5*15]
    ny=(yl[1]-yl[0])/0.05
    xscan=AxisScan(st_move_x,xl,nx)
    yscan=AxisScan(st_move_x,yl,ny)

    rz=5
    nz=rz/0.1
    z0=8
    zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    
    psfscan=Scan([[xscan],[yscan],[zscan]])
    # psfscan=Scan([[xscan],[yscan]])
    dims=psfscan.dims
    prod=1
    for d in dims:
        prod*=d
    
    # prefuncs=[[trf_flashlamp_init],[fm.Move,height],[apertures,1,1],[get_hv]]
    # psfscan.functions([[psfscan.currentIndex],[kaleido_trf_flashlamp,50,50,400,1,0]])
    # prefuncs=[[lum_init],[fm.Move,height],[apertures,1,1],[get_hv]]
    prefuncs=[[trf_flashlamp_init],[apertures,0,0],[get_hv],psfscan.dims]
    psfscan.functions([[psfscan.currentIndex],[kaleido_lum,50]])
    print(psfscan.dims)
    cmt = "psf_testing"
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)

    with open(fname,'a') as f:
        f.write(f"{comment}:{socket.gethostname()}\n")
        f.write(f"precalled func:")
        writer=csv.writer(f, delimiter=';', dialect='excel-tab')
        h = await psfscan.header(prefuncs)
        f.write(h+"\n")
    
    counter=0
    # actual core functions with or without header
    with open(fname,'a') as f:
        writer=csv.writer(f, delimiter='\t', dialect='excel-tab')
        str=await psfscan.header()
        f.write(str)
        
        for i in range(prod):
            # print(output)
            output=await psfscan.next()
            tstr=datetime.now().strftime("%y.%m.%d.%H.%M.%S.%f")
            writer.writerows([list([tstr,*output])])
            print(counter)
            print(output)
            counter+=1

    # post functions for cleaning up
    # for d in postfuncs:
    #     out = await d[0](*d[1:len(d)])

    print(f"done!:\t{inspect.stack()[0][3]}")



# fleming.hta.fleming_measurement.plate_batch2
async def plate_batch2():
    for h in range(12,14):
    # for h in range(7,17):
        await plate_batch(h,"blackOpti")

# fleming.hta.fleming_measurement.plate_batch
async def plate_batch(height,comment=""):
    h=[[fm.Move,height]]
    await scanTable_init()
    prefuncs_post=[[scanPlate,[1,16],[1,24]]]+h # # row=[1,2],column=[3,4]):    
    # prefuncs_post=[[scanPlate,[1,1],[1,2]]]+h # # row=[1,2],column=[3,4]):    
    funcs_pre=[[scanPlate]]
    repeat=(prefuncs_post[0][1][1]-prefuncs_post[0][1][0]+1)*(prefuncs_post[0][2][1]-prefuncs_post[0][2][0]+1)
    print(repeat)
    await trf_batch(repeat,prefuncs_post,funcs_pre,comment)
    await alpha_batch(repeat,prefuncs_post,funcs_pre,comment)
    await lum_batch(repeat,prefuncs_post,funcs_pre,comment)
    # await fi_batch(repeat,prefuncs_post,funcs_pre,comment)

async def plate_batch3(height=12,comment="kaleidoCMP"):
    h=[[fm.Move,height]]
    await scanTable_init()
    prefuncs_post=[[scanPlate,[1,16],[1,24]]]+h # # row=[1,2],column=[3,4]):    
    # prefuncs_post=[[scanPlate,[1,1],[1,2]]]+h # # row=[1,2],column=[3,4]):    
    funcs_pre=[[scanPlate]]
    repeat=(prefuncs_post[0][1][1]-prefuncs_post[0][1][0]+1)*(prefuncs_post[0][2][1]-prefuncs_post[0][2][0]+1)
    print(repeat)
    await trf_batch(repeat,prefuncs_post,funcs_pre,comment)

async def batch():
    repeat=200
    if False:
        await initialize_instrument()
        time.sleep(1)
        await trf_go()
        time.sleep(1)
        await pmt1_target_temp(25.)
        await pmt2_target_temp(25.)
        await cooling(0,0)
        time.sleep(3)
        await cooling(1,1)
        time.sleep(3)

    # await initialize_instrument()

    prepost=[]# [[coolingControl,25.0]]
    await lum_batch(repeat,prepost)
    await trf_batch(repeat,prepost)
    await alpha_batch(repeat,prepost)
    await fi_batch(repeat,prepost)
    
    
async def absoluteScan(height=12,comment=""):
    r=3.6
    n=3
    h=[[fm.Move,height]]
    well_prefuncs=[[scanWell,[r,n],[r,n]]] # # row=[1,2],column=[3,4]):    
    well_funcs=[[scanWell],[kaleido_trf_laser,10,50,400,1,0],[get_all_temp]]
    well_repeat=n*n
    cmt="trf_absolutePositionScan" + comment
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,well_prefuncs)

    await adaptor(cmt,fname,timestamp,well_prefuncs,well_funcs,well_repeat)
    return


# fleming.hta.fleming_measurement_test.cooling_peltier_batch
async def cooling_peltier_batch():
    repeat=10
    timestamp=True
    await darkcount_measurement_init()
    
    cmt="darkcount_full_peltier"
    prefuncs=[[apertures,0,0],[set_hv, 0.5,0.5],[get_hv],[set_fan_speed,0.5],[set_tec_full]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
    # prefuncs=[[apertures,0,0],[set_hv, 0.5,0.5],[get_hv],[set_tec_full]]
    # prefuncs=[[apertures,0,0],[set_hv, 0.5,0.5],[get_hv]]
    # funcs=[[kaleido_darkcount,1000],[get_all_temp],[updateTarget_c]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
    funcs=[[kaleido_darkcount,1000],[get_all_temp]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
    postfuncs=[]  # -1:1.6; 0: close; 1:3
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)


async def fan_testing():
    repeat=30
    timestamp=True
    await darkcount_measurement_init()
    
    cmt="fan_speed_testing"
    prefuncs=[[apertures,0,0],[set_hv, 0.5,0.5],[get_hv]]
    funcs=[[kaleido_darkcount,1000],[fan_speed_switch],[get_all_temp],[sleep, 5]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
    postfuncs=[]  # -1:1.6; 0: close; 1:3
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)


# humidity at 30 degree should be lower than 30% to reach 6 degreee without condensation
# 	1.  rt(15, 20, 25, 30), low humidity
# 	2. Tec full, target_temperature
#   3. Fan speed dependency.
# fleming.hta.fleming_measurement_test.cooling_limit_batch
async def cooling_limit_batch(repeat=2,sleeptime=3):  # 12 hours * 4 = 48
    timestamp=True
    await darkcount_measurement_init()
    await apertures(0,0)
    await set_hv(0.5,0.5)

    try:
        # full workload peltier, change fun speed and check the temperature
        cmt="darkcount_full_peltier"
        funspeed=linspace(0.5,1,6)
        print(funspeed)

        for s in funspeed:
            prefuncs=[[get_hv],[set_fan_speed,s],[set_tec_full]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
            # funcs=[[kaleido_darkcount,1000],[get_all_temp],[updateTarget_c]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
            funcs=[[kaleido_darkcount,1000],[get_all_temp]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
            postfuncs=[[set_tec_full, 0],[sleep, sleeptime]]  # -1:1.6; 0: close; 1:3
            fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
            await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)

        # set target temperature low enough and change fun speed, chech temperature
        cmt="darkcount_target_temp"
        target_c=8
        funspeed=linspace(0.5,1,6)
        
        for s in funspeed:
            prefuncs=[[get_hv],[set_fan_speed,s],[pmt_target_c,target_c]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
            # funcs=[[kaleido_darkcount,1000],[get_all_temp],[updateTarget_c]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
            funcs=[[kaleido_darkcount,1000],[get_all_temp]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
            postfuncs=[[set_tec_full, 0],[sleep, sleeptime]]  # -1:1.6; 0: close; 1:3
            fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
            await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)
        
    except:
        pmt_target_c(25.0)
        
    pmt_target_c(25.0)
    
# temperature 25, humidity goes from 30 ~ 70%
async def humidity_batch(repeat=2,sleeptime=3):
    timestamp=True
    await darkcount_measurement_init()
    await apertures(0,0)
    await set_hv(0.5,0.5)

    try:
        # full workload peltier, change fun speed and check the temperature
        cmt="humidity_check"
        # funspeed=linspace(0.5,1,6)
        # print(funspeed)

        prefuncs=[[get_hv],[set_fan_speed,0.5],[set_tec_full,1.0]]  # -1:1.6; 0: close; 1:3; fms: 1, trf lance module with lens inside,2, lum, module, 3, alha module
        # funcs=[[kaleido_darkcount,1000],[get_all_temp],[updateTarget_c]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
        funcs=[[kaleido_darkcount,1000],[get_all_temp]] # measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0 
        postfuncs=[[set_tec_full, 0],[sleep, sleeptime]]
        fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
        await adaptor(cmt,fname,True,prefuncs,funcs,repeat,postfuncs)
    except:
        await pmt_target_c(25.0)
        
    await pmt_target_c(25.0)
    
# fleming.hta.fleming_measurement_test.climateChamber_batch    
async def climateChamber_batch():
    repeat=3290
    # sleeptime=300
    # # temperature limit
    # await myInitialization()
    # await sleep(60*19)
    # for i in range(3):
    #     await cooling_limit_batch(repeat,sleeptime)
    # humidity check: constant c = 25, changing humidity and set a fixed tec, monitor the temperature
    sleeptime=0.1
    await humidity_batch(repeat*6,sleeptime)
    
    await pmt_target_c(25.0)


async def mysleep(dt=0.1):
    sleep(dt)

# fleming.hta.fleming_measurement_test.illuminationSwitch
async def illuminationSwitch(mode="alpha"):
            # Set default parameter values
    try:
        await myInitialization()
        pass
    except:
        print("error in initialization! skip error and continue!")

    st = VUnits.instance.hal.scan_table
    await scanTable_init("'96 Test Plate'")
    await st.Move(60,0)

    tr=[250, 280]
    t=AxisScan(mysleep,tr,tr[1]-tr[0])
    
    elsrange=tr
    elsScan=AxisScan(els.Move,elsrange,tr[1]-tr[0])
    timeseries=Scan([[t,elsScan]])
    
    # Hamburg: 20220908, after good els and IAT module. 
    # els: 248.98
    # filter module: 56.96
    # bottom light director:  242.55
    # scan table
    # 

    if mode == "alpha":
        # prefuncs=[[els.Move,248.98],[bld.Move,242.55],[fms.Move,56.96]]
        prefuncs=[[alpha_init],[els.Move,248.98],[bld.Move,242.55],[fms.Move,32.96]]
    #exc_power=0.38, exc_time_ms = 180, det_time_ms = 370, pause_ms=1, ref_window_ms = 5
        timeseries.functions([[timeseries.currentIndex],[kaleido_alpha,0.3,200,50,1,5],[mysleep,0.1]])
    elif mode=="lamp":
        prefuncs=[[els.Move,248.98],[bld.Move,242.55],[fms.Move,56.96]]
        timeseries.functions([[timeseries.currentIndex],[kaleido_FI,0.001],[mysleep,0.01]])
    elif mode=="TRF":
        prefuncs=[[els.Move,248.98],[bld.Move,242.55],[fms.Move,56.96]]
        # (measurementTime=100,  delay_us=50, windowTime_us=200, numberOfWindows = 1, windowPauseTime_us=0):
        timeseries.functions([[timeseries.currentIndex],[kaleido_trf_laser,1,10,100,1,0],[mysleep,0.1]])

    print(timeseries.dims)

    h = await timeseries.header(prefuncs)

    counter=0
    dims=timeseries.dims
    prod=1
    for d in dims:
        prod*=d
    for i in range(prod):
        # print(output)
        output=await timeseries.next()
        tstr=datetime.now().strftime("%y.%m.%d.%H.%M.%S.%f")
        print(counter)
        print(output)
        counter+=1

    print(f"done!:\t{inspect.stack()[0][3]}")

async def fm_cycle():
    t=AxisScan(fm.Move,[0,15],15)
    scan1d=Scan([[t]])
    dims=scan1d.dims
    prod=1
    for d in dims:
        prod*=d
    
    prefuncs=[]
    scan1d.functions([[mysleep,0.4]])
    counter=0
    for i in range(prod):
        # print(output)
        output=await scan1d.next()
        tstr=datetime.now().strftime("%y.%m.%d.%H.%M.%S.%f")
        print(counter)
        print(output)
        counter+=1

# fleming.hta.fleming_measurement_test.psf_measurement
async def psf_exc_top(z0=12,wellx=1,welly=1):
        
    st = VUnits.instance.hal.scan_table
    await scanTable_init("'96 Test Plate'")
    await st.MoveToWell(wellx,welly)
    
    # well
    r=3.6
    n=2
    rz=7
    nz=3
    
    x0,y0 = st.get_current_position()
    
    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)

    zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    
    psfscan=Scan([[xscan],[yscan],[zscan]])
    # psfscan=Scan([[xscan],[yscan]])
    dims=psfscan.dims
    prod=1
    for d in dims:
        prod*=d
    
    psfscan.functions([[psfscan.currentIndex],[kaleido_abs,0.1]])
    print(psfscan.dims)
    return psfscan

# fleming.hta.fleming_measurement_test.psf_exc_pilotlaser_measure
async def psf_exc_pilotlaser_measure():
    await myInitialization()
    # prefuncs=[[els.Move,248.98],[bld.Move,242.55],[fms.Move,32.96]]
    # prefuncs=[[els.Move,203.7],[bld.Move,242.55],[fms.Move,56.96]]

    # well
    wellx=1
    welly=1
    z0=10
    r=1
    n=3
    # n=21
    rz=7
    nz=7
    
    st=scan_table
    await scanTable_init("'96 Test Plate'")
    # await st.MoveToWell(wellx,welly)
    # await st.Move()
    # x0,y0 = await scantable_location(75.38,156.885) # hamburg
    x0,y0 = await scantable_location(76.0,158.11) # swangsea

    x0,y0 = st.get_current_position()
    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
    psfscan=Scan([[xscan],[yscan]])
    # zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    # psfscan=Scan([[xscan],[yscan],[zscan]])
    prod=psfscan.lenprod()
    
    # prefuncs=[[abs_init,"1006"],[apertures,0,0],[els.Move,203.7],[bld.Move,242.55],[fms.Move,56.96],[bld.Move,197.5]]
    prefuncs=[[abs_init,"1006"],[apertures,0,0],[els.Move,248.19],[fms.Move,56.4],[bld.Move,200.5],[fm.Move,10]]
    # psfscan.functions([[psfscan.currentIndex],[kaleido_abs,0.1]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    # psfscan.functions([[psfscan.currentPos],[kaleido_abs,0.1]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    psfscan.functions([[psfscan.currentPos],[st.get_current_position],[kaleido_abs,100,True]])

    cmt = "pilotlaser_exc"
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)

    # await   psfscan.header(prefuncs)
    # pd = VUnits.instance.hal.plateDoor
    # await pd.UseProfile(1)    
    # await pd.Close()

    await psfscan.run(fname,cmt, prefuncs=[])
    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")
    return

# fleming.hta.fleming_measurement_test.psf_flashlampp_els_deviation_batch
async def psf_flashlampp_els_deviation_batch():
    # await psf_exc_lamp_measure(elsloc=204.0015)
    # await psf_exc_lamp_measure(elsloc=23.765)
    els1=[x+22.0806 for x in [0,0.2,0.4,0.8,1.6,3.2]]
    z0=7.5
    for e in els1:
        await psf_exc_lamp(e,z0,f"lamp_els_{e}")

    els2=[x+202.3375 for x in [0,0.2,0.4,0.8,1.6,3.2]]
    z0=10.5
    for e in els2:
        await psf_exc_lamp(e,z0,f"lamp_els_{e}")


# fleming.hta.fleming_measurement_test.psf_flashlampDirect_batch
async def psf_flashlampDirect_batch():
    # await psf_exc_lamp_measure(elsloc=204.0015)
    # await psf_exc_lamp_measure(elsloc=23.765)
    z0=7.5
    await psf_exc_lamp(80.555,z0,"lamp_direct")

    z0=10.5
    await psf_exc_lamp(263.35,z0,"lamp_direct")



# fleming.hta.fleming_measurement_test.psf_exc_alpha_measure
async def psf_exc_alpha(elsloc=204.0015,z0=10,comment=""):
    await myInitialization()


    elsloc=205
    # well
    wellx=1
    welly=1
    r=4
    n=5
    rz=9
    nz=10

    # x0,y0 = await scantable_location(75.38,156.885)
    # x0,y0 = await scantable_location(75.87,158.365)
    # x0,y0 = await scantable_location(75.87,158.365)
    x0,y0 = await scantable_location(75.07,157.11)

    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
    psfscan=Scan([[xscan],[yscan]])
    # zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    # psfscan=Scan([[xscan],[yscan],[zscan]])
    psfscan.functions([[psfscan.currentPos],[kaleido_alpha_photodiode,100]])
    print(psfscan.dims)

    cmt = inspect.stack()[0][3]+comment
    timestamp=True

    # measHeight = 8, measTime = 100, filterModule = 4001, numberOfWindows = 1, delay_us = 100, windowTime_us = 100, photoDiode=True

    prefuncs=[[alpha_photo_init],[apertures,0,0],[els.Move,elsloc],[fms.Move,56.4],[bld.Move,200.5]]
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    
    print(fname)
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")


# fleming.hta.fleming_measurement_test.psf_exc_trfLaser_scan
async def psf_exc_trfLaser_scan():
    elsloc=242.22
    elsloc=248.22
    await psf_exc_trfLaser(elsloc,z0=12.5)
    # elsloc=243.22
    # await psf_exc_trfLaser_measure(elsloc,z=12.5)

    # elsloc=248.92
    # await psf_exc_trfLaser_measure(elsloc)
    

# fleming.hta.fleming_measurement_test.psf_exc_trfLaser
# async def psf_exc_trfLaser_measure(elsloc=242.22,z0=12.5,comment=""):
async def psf_exc_trfLaser(elsloc=248.4,z0=11.0,comment=""):
    elsloc=248.85
    # await myInitialization()
    # well
    wellx=1
    welly=1
    r=4
    n=21
    rz=6
    nz=7

    x0,y0 = await scantable_96plate_location(1,1)
    
    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
    # psfscan=Scan([[xscan],[yscan]])
    zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    psfscan=Scan([[xscan],[yscan],[zscan]])

    await els.Home()
    # prefuncs=[[trf_laser_photo_init,1006],[apertures,0,0],[els.Move,elsloc],[fm.Move,z0],[bld.Move,200],[get_all_mover_positions]]
    prefuncs=[[trf_laser_photo_init,1006],[apertures,0,0],[els.Move,elsloc],[fm.Move,z0],[bld.Move,200],[get_all_mover_positions]]
    psfscan.functions([[psfscan.currentPos],[kaleido_trf_laser_photodiode,100, 100, 200]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    # prefuncs=[[trf_laser_photo_init,1006],[apertures,0,0],[fm.Move,12.5],[bld.Move,200],[get_all_mover_positions]]
    # psfscan.functions([[psfscan.currentPos],[kaleido_trf_laser_photodiode,100, 100, 200]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0


    cmt = inspect.stack()[0][3]+comment
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    print(fname)
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")
    print(x0,y0)


# fleming.hta.fleming_measurement_test.psf_batch
async def psf_batch():
    # await psf_exc_lamp_measure(elsloc=204.0015)
    # await psf_exc_lamp_measure(elsloc=23.765)
    z0=7.5
    # await psf_exc_lamp_measure(22.0806,z0)
    await psf_exc_lamp(23.4035,z0)
    z0=10.5
    # await psf_exc_lamp_measure(202.372,z0)
    # await psf_exc_lamp_measure(202.3375,z0)
    await psf_exc_lamp(203.645,z0)
    

# fleming.hta.fleming_measurement_test.psf_exc_lamp
async def psf_exc_lamp(elsloc=204.0015,z0=10,comment=""):
    elsloc=203.42
    elsloc=203.62
    # elsloc=21.76

    await myInitialization()

    # well
    wellx=1
    welly=1
    r=4
    n=21
    rz=9
    nz=10

    # x0,y0 = await scantable_location(75.38,156.885)
    # x0,y0 = await scantable_location(75.87,158.365)
    # x0,y0 = await scantable_location(75.87,158.365)
    # x0,y0 = await scantable_location(75.07,157.11)

    x0,y0 = await scantable_96plate_location(1,1)
    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
    # psfscan=Scan([[xscan],[yscan]])
    zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    psfscan=Scan([[xscan],[yscan],[zscan]])
    psfscan.functions([[psfscan.currentPos],[kaleido_abs,0.01,False]])
    print(psfscan.dims)

    cmt = inspect.stack()[0][3]+comment
    timestamp=True
    prefuncs=[[abs_init,1006],[fm.Move,12.5],[apertures,0,0],[els.Move,elsloc],[bld.Move,200.5]]
    # prefuncs=[[abs_init,"1006"],[fm.Move,12.5],[apertures,0,0],[els.Move,elsloc],[bld.Move,200.5]]
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    
    print(fname)
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")



# fleming.hta.fleming_measurement_test.psf_exc_pilot_measure
async def psf_exc_pilot_measure(elsloc=248.19):
    await myInitialization()
    # prefuncs=[[els.Move,248.98],[bld.Move,242.55],[fms.Move,32.96]]
    # prefuncs=[[els.Move,203.7],[bld.Move,242.55],[fms.Move,56.96]]
    await scantable_96plate_location(1,1)

    elsloc=248.98
    # well
    wellx=1
    welly=1
    z0=10
    r=1
    n=11
    rz=9
    nz=10

    # x0,y0 = await scantable_location(75.87,158.365)
    # x0,y0 = await scantable_location(75.82,158.31)
    x0,y0 = await scantable_location(75.07,157.11)
                                    # 75.38,156.885)

    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
    # psfscan=Scan([[xscan],[yscan]])
    zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    psfscan=Scan([[xscan],[yscan],[zscan]])
    psfscan.functions([[psfscan.currentPos],[kaleido_abs,100,True]])
    print(psfscan.dims)

    cmt = "psf_exc_pilot_3D_IAR+lens"
    timestamp=True
    prefuncs=[[abs_init,"1006"],[els.Move,elsloc],[fms.Move,54.5],[bld.Move,200.5]]
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    
    print(fname)
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")


# fleming.hta.fleming_measurement_test.psf_exc_alpha
async def psf_exc_alpha(elsloc=243.14,z0=12.5):
    await myInitialization()
    # well
    wellx=1
    welly=1
    z0=10
    r=4
    n=21
    rz=9
    nz=10

    # x0,y0 = await scantable_location(75.38,156.885)
    x0,y0 = await scantable_96plate_location(1,1)
    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
    # psfscan=Scan([[xscan],[yscan]])
    zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    psfscan=Scan([[xscan],[yscan],[zscan]])
    
    await els.Home()
    prefuncs=[[alpha_photo_init],[apertures,0,0],[els.Move,elsloc],[fm.Move,z0],[bld.Move,200],[get_all_mover_positions]]
    psfscan.functions([[psfscan.currentPos],[kaleido_alpha_photodiode,0.01]]) # second # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0

    # prefuncs=[[alpha_init],[apertures,0,0],[els.Move,elsloc],[bld.Move,200]]
    # psfscan.functions([[psfscan.currentPos],[kaleido_alpha_photodiode]])

    cmt = inspect.stack()[0][3]
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await psfscan.run(fname,cmt,prefuncs)
    
    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")


# fleming.hta.fleming_measurement_test.psf_exc_det_FI_measure
async def psf_exc_det_FI_measure(elsloc=202.3375,z0=12.5):
    await myInitialization()
    # prefuncs=[[els.Move,248.98],[bld.Move,242.55],[fms.Move,32.96]]
    # prefuncs=[[els.Move,203.7],[bld.Move,242.55],[fms.Move,56.96]]

    # well
    wellx=1
    welly=4
    r=4
    n=21
    rz=9
    nz=10

    # x0,y0 = await scantable_location(75.38,156.885)
    x0,y0 = scan_table.get_current_position()
    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
    # psfscan=Scan([[xscan],[yscan]])
    zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    psfscan=Scan([[xscan],[yscan],[zscan]])
    psfscan.functions([[psfscan.currentPos],[kaleido_FI,0.1]])
    print(psfscan.dims)


    cmt = "psf_exc_det_FI"
    timestamp=True
    prefuncs=[[abs_init,1006],[apertures,0,0],[els.Move,elsloc],[fms.Move,54.5],[bld.Move,200.5],[das1.Move,11.45], [das2.Move,11.7]]
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    
    # await myalpha_on(0.3)
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")


# fleming.hta.fleming_measurement_test.psf_det_lamp_batch
async def psf_det_lamp_batch():
    await psf_det_lamp_measure(202.3375,10,"psf")
    # await psf_det_lamp_measure(202.3375,10,"psf")

# fleming.hta.fleming_measurement_test.psf_lum_trf_batch
async def psf_lum_trf_batch():
    cmt = 'Lum'
    z0=12.5
    # await psf_det_lum_pinhole(z0,cmt, -0.9)
    # await psf_det_lum_pinhole(z0,cmt,-1.6)
    # await psf_det_lum_pinhole(z0,cmt,0.4)
    # await psf_det_lum_pinhole(z0,cmt,-0.4)
    # return
    await psf_det_lum_pinhole(z0,cmt,0)
    return
    elsloc=242.22
    await psf_exc_trfLaser(elsloc,z0)
    # elsloc=243.22
    # await psf_exc_trfLaser_measure(elsloc,z0=12.5)


# fleming.hta.fleming_measurement_test.psf_det_lum_pinhole
async def psf_det_lum_pinhole(z0=12.5,cmt="psf_det_3D",das1_shift=0,das2_shift=0):
    await myInitialization()
    wellx=4
    welly=3
    # z0=10
    r=4
    n=21
    rz=9
    nz=10
    wellx=3
    welly=1
    await scantable_96plate_location(wellx,welly)

    # wellx=11
    # welly=6
    # await scantable_384plate_location(wellx,welly)
    await fm.Move(z0)

    st = VUnits.instance.hal.scan_table
    x0,y0 =  st.get_current_position()
    
    xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
    psfscan=Scan([[xscan],[yscan]])
    # zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    # psfscan=Scan([[xscan],[yscan],[zscan]])
    psfscan.functions([[psfscan.currentPos],[kaleido_lum,100]])
    print(psfscan.dims)

    timestamp=True
    await apertures(1,1)
    pos=await get_all_mover_positions()
    await das1.Move(pos['das1_pos']+das1_shift)
    await das2.Move(pos['das2_pos']+das2_shift)
    

    prefuncs=[[lum_init,"1006"],[get_all_mover_positions]]
    # prefuncs=[[lum_init,"4003"],[get_all_mover_positions]]
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    hv1,hv2=await get_hv()
    print(hv1,hv2)
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")



async def psf_det_lamp_measure(elsloc=202.3375,z0=10,cmt="psf"):
    pass
    # # await scantable_96plate_location(wellx,welly)
    # await scantable_384plate_location(wellx,welly)
    
    # st = VUnits.instance.hal.scan_table
    # x0,y0 =  st.get_current_position()
    # # pd = VUnits.instance.hal.plateDoor
    # # await pd.UseProfile(1)    
    # # await pd.Open()
    # # return
    # xscan=AxisScan(st_move_x,[-r/2+x0,r/2+x0],n)
    # yscan=AxisScan(st_move_y,[-r/2+y0,r/2+y0],n)
    # psfscan=Scan([[xscan],[yscan]])
    # # zscan=AxisScan(fm.Move,[z0-rz/2,z0+rz/2],nz)
    # # psfscan=Scan([[xscan],[yscan],[zscan]])
    # psfscan.functions([[psfscan.currentPos],[kaleido_FI,0.01]])
    # print(psfscan.dims)

    # timestamp=True
    # await FI_init(filter_ID=1006, meas_height=15, meas_time=100, num_wells=384, top_meas=True)
    # prefuncs=[[abs_init,"1006"],[apertures,1,1],[els.Move,elsloc],[fms.Move,56.96],[get_hv],[get_dl]]
    # fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    # hv1,hv2=await get_hv()
    # print(hv1,hv2)
    # # await myalpha_on(0.3)
    # await psfscan.run(fname,cmt,prefuncs)

    # print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")




# fleming.hta.fleming_measurement_test.det_aperture_scan
async def det_aperture_scan(elsloc=204.0015):
    await myInitialization()

    # well
    # wellx=7
    # welly=3

    # await scantable_96plate_location(wellx,welly)
    # imp.reload(scantable_384plate_location)
    # await scantable_384plate_location(wellx,welly)
    wellx=3
    welly=1
    await scantable_96plate_location(wellx,welly)
    # pd = VUnits.instance.hal.plateDoor
    # await pd.UseProfile(1)    
    # await pd.Close()
    # await fm.Move(15)
    # await eject()
    # return

    das1 = VUnits.instance.hal.detectorApertureSlider1
    das2 = VUnits.instance.hal.detectorApertureSlider2

    pos1 = round(das1.get_config(das_enum.Positions.Min), 2)
    pos2 = round(das2.get_config(das_enum.Positions.Min), 2)

    max1 = 20
    # das1.get_config(das_enum.Positions.Max-1)
    max2 = 20
    # das2.get_config(das_enum.Positions.Max-1)

    dp=1
    n=round((max1-pos1)/dp)

    das1scan=AxisScan(das1.Move,[pos1,max1],n)
    das2scan=AxisScan(das2.Move,[pos2,max2],n)
    psfscan=Scan([[das1scan,das2scan]])
    # psfscan=Scan([[das1scan]])
    # get_all_mover_positions
    psfscan.functions([[psfscan.currentPos],[kaleido_lum,100]])
    print(psfscan.dims)

    cmt = "det_aperture_1D"
    timestamp=True
    prefuncs=[[abs_init,"1006"],[fms.Move,54.5],[fm.Move,6]] #,[set_dl, 0.245,0.246],[set_hv,0.455,0.455],[get_hv],[get_dl]] # 
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    hv1,hv2=await get_hv()
    print(hv1,hv2)
    
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")


# fleming.hta.fleming_measurement_test.det_aperture_FI_scan
async def det_aperture_FI_scan(elsloc=204.0015):
    await myInitialization()
    wellx=1
    welly=4
    elsloc=202.372
    # await scantable_96plate_location(wellx,welly)
    await scantable_96plate_location(wellx,welly)

    das1 = VUnits.instance.hal.detectorApertureSlider1
    das2 = VUnits.instance.hal.detectorApertureSlider2

    await get_all_mover_positions()
    pos1 = round(das1.get_config(das_enum.Positions.Min), 2)
    pos2 = round(das2.get_config(das_enum.Positions.Min), 2)

    max1 = das1.get_config(das_enum.Positions.Max)
    max2 = das2.get_config(das_enum.Positions.Max)

    dp=0.05
    n=round((max1-pos1)/dp)

    das1scan=AxisScan(das1.Move,[pos1,max1],n)
    das2scan=AxisScan(das2.Move,[pos2,max2],n)
    psfscan=Scan([[das1scan,das2scan]])
    # psfscan=Scan([[das1scan]])
    # get_all_mover_positions
    await FI_init(filter_ID=1001, meas_height=15, meas_time=100, num_wells=96, top_meas=True)

    psfscan.functions([[psfscan.currentPos],[kaleido_FI,100]])
    print(psfscan.dims)

    cmt = "det_aperture_FI"
    timestamp=True
    # prefuncs=[[abs_init,"1006"],[els.Move,elsloc],[fms.Move,56.96],[fm.Move,11]] #,[set_dl, 0.245,0.246],[set_hv,0.455,0.455],[get_hv],[get_dl]] # 
    prefuncs=[[els.Move,elsloc],[fms.Move,54.5],[fm.Move,11]] #,[set_dl, 0.245,0.246],[set_hv,0.455,0.455],[get_hv],[get_dl]] # 
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    hv1,hv2=await get_hv()
    print(hv1,hv2)
    
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t\n\n{fname}\n\n")



# fleming.hta.fleming_measurement_test.bottomlightRoughAlign
async def bottomlightRoughAlign():
    await myInitialization()
    # prefuncs=[[els.Move,248.98],[bld.Move,242.55],[fms.Move,32.96]]
    # prefuncs=[[els.Move,203.7],[bld.Move,242.55],[fms.Move,56.96]]
    # await header_output_Gen(prefuncs)
    await scantable_location(75.38,156.885)
    # await fm.Move(0) 
    l=130
    r=260
    n=(r-l)*4
    bldscan=AxisScan(bld.Move,[l,r],n)
    
    psfscan=Scan([[bldscan]])
    # psfscan=Scan([[xscan],[yscan]])
    dims=psfscan.dims
    prod=1
    for d in dims:
        prod*=d
    
    prefuncs=[[abs_init,"1006"],[fm.Move,12],[apertures,0,0],[els.Move,203.7],[fms.Move,56.96]]
    psfscan.functions([[psfscan.currentPos],[kaleido_abs,0.1,False]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    print(psfscan.dims)
    cmt = "lamp_bld_full_scan"
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await psfscan.run(fname,cmt,prefuncs)


    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")


# fleming.hta.fleming_measurement_test.fms_photonDiode_trf_scan
async def fms_photonDiode_trf_scan(z0=13.5):
    await myInitialization()
    # prefuncs=[[els.Move,248.98],[bld.Move,242.55],[fms.Move,32.96]]
    # prefuncs=[[els.Move,203.7],[bld.Move,242.55],[fms.Move,56.96]]
    # await header_output_Gen(prefuncs)
    # await scantable_location(75.38,156.885) # Hamburg
    x0,y0 = await scantable_96plate_location(1,1)
    # await st.Home()
    filterModule=1006
    # await scantable_location(75.85,	158.31) # swansea
    await VUnits.instance.hal.filterModuleSlider.SelectModuleWithId(filterModule)
    pos=await get_all_mover_positions()
    pos=pos['fms_pos']
    print(pos)
    # await fm.Move(0) 
    r=10
    n=round(r/0.1)
    fmsscan=AxisScan(fms.Move,[pos-r/2,pos+r/2],n)
    
    psfscan=Scan([[fmsscan]])

    prefuncs=[[trf_laser_photo_init,filterModule],[fm.Move,z0],[bld.Move,200],[get_all_mover_positions]]
    psfscan.functions([[psfscan.currentPos],[kaleido_trf_laser_photodiode,10, 10, 1]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    
    cmt = inspect.stack()[0][3]
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await psfscan.run(fname,cmt,prefuncs)
    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")


# fleming.hta.fleming_measurement_test.els_photonDiode_alpha_scan
async def els_photonDiode_alpha_scan():
    await myInitialization()
    # await header_output_Gen(prefuncs)
    # await scantable_location(75.38,156.885) # Hamburg
    # x0,y0 = await scantable_96plate_location(1,1)
    # await scantable_location(75.85,	158.31) # swansea
    # await st.Home()
    await scantable_96plate_location(1,1)
    # await fm.Move(0)
    l=0
    r=360
    # l=236
    # r=252
    n=(r-l)*10+1
    l=246
    r=249
    l=241
    r=246
    n=round((r-l)*50+1)
    
    elsscan=AxisScan(els.Move,[l,r],n)
    # elsscan=AxisScan(timeSeries,[l,r],n)
    
    psfscan=Scan([[elsscan]])
    
    prefuncs=[[alpha_photo_init],[apertures,0,0],[fm.Move,12.5],[bld.Move,200],[get_all_mover_positions]]
    # psfscan.functions([[psfscan.currentPos],[kaleido_trf_laser_photodiode,100, 100, 1]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    # psfscan.functions([[psfscan.currentPos],[kaleido_trf_laser,100, 100, 1]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    psfscan.functions([[psfscan.currentPos],[kaleido_alpha_photodiode]]) # second # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    # psfscan.functions([[psfscan.currentPos],[kaleido_trf_laser_photodiode,100, 100, 200]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    
    cmt = inspect.stack()[0][3]
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await psfscan.run(fname,cmt,prefuncs)
    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")




# fleming.hta.fleming_measurement_test.els_photonDiode_trf_scan
async def els_photonDiode_trf_scan(z0=13.5):
    await myInitialization()
    # await header_output_Gen(prefuncs)
    # await scantable_location(75.38,156.885) # Hamburg
    # x0,y0 = await scantable_96plate_location(1,1)
    # await scantable_location(75.85,	158.31) # swansea
    # await st.Home()
    await scantable_96plate_location(1,1)
    # await fm.Move(0)
    l=0
    r=360
    # l=236
    # r=252
    n=(r-l)*10+1
    l=246
    # r=249
    r=252
    n=round((r-l)*40+1)
    elsscan=AxisScan(els.Move,[l,r],n)
    
    psfscan=Scan([[elsscan]])
    
    prefuncs=[[trf_laser_photo_init,1006],[apertures,0,0],[els.Home],[fm.Move,z0],[bld.Move,200],[get_all_mover_positions]]
    psfscan.functions([[psfscan.currentPos],[kaleido_trf_laser_photodiode,100, 100, 200]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    
    cmt = inspect.stack()[0][3]
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await psfscan.run(fname,cmt,prefuncs)
    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")


# fleming.hta.fleming_measurement_test.els_photonDiode_align
async def els_photonDiode_align():
    await myInitialization()
    # prefuncs=[[els.Move,248.98],[bld.Move,242.55],[fms.Move,32.96]]
    # prefuncs=[[els.Move,203.7],[bld.Move,242.55],[fms.Move,56.96]]
    # await header_output_Gen(prefuncs)
    # await scantable_location(75.38,156.885) # Hamburg
    # await scantable_location(75.85,	158.31) # swansea
    await scantable_96plate_location(1,1)

    # await fm.Move(0) 
    l=0
    r=360
    n=(r-l)*4
    # n=(r-l)
    elsscan=AxisScan(els.Move,[l,r],n)
    
    psfscan=Scan([[elsscan]])
    # psfscan=Scan([[xscan],[yscan]])
    dims=psfscan.dims
    prod=1
    for d in dims:
        prod*=d
    
    prefuncs=[[abs_init,"1006"],[fm.Move,12],[fms.Move,56.96],[bld.Move,196]]
    # psfscan.functions([[psfscan.currentPos],[kaleido_abs,0.1,False]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    psfscan.functions([[psfscan.currentPos],[kaleido_abs,100,True]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    print(psfscan.dims)
    cmt = inspect.stack()[0][3]
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    await psfscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")


# async def search(x):
#     await els.Move(x)
#     re=await kaleido_abs(100,False)

#     return re['signal']

# # fleming.hta.fleming_measurement_test.els_flashlamp_search
# async def els_flashlamp_search(rg=[13,30]):
#     await myInitialization()
#     x0,y0 = await scantable_location(75.87,158.365)
#     # await fm.Move(0) 
#     l=rg[0]
#     r=rg[1]

#     # l=197
#     # r=208

#     n=(r-l)*50
#     elsscan=AxisScan(els.Move,[l,r],n)
    
#     psfscan=Scan([[elsscan]])
#     # psfscan=Scan([[xscan],[yscan]])
#     dims=psfscan.dims
#     prod=1
#     for d in dims:
#         prod*=d
    
#     prefuncs=[[abs_init,"1006"],[fm.Move,8.5],[fms.Move,56.4],[bld.Move,200.5]]
#     # psfscan.functions([[psfscan.currentPos],[kaleido_abs,0.1,False]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
#     psfscan.functions([[psfscan.currentPos],[kaleido_abs,1000,False]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
#     print(psfscan.dims)
#     cmt = "lamp_els_full_scan"
#     timestamp=True
#     fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)

#     await psfscan.header(prefuncs)
#     dx=await prediction(20,21,search,tol=0.01,maxIter=100, range=5) # prediction(x0,x1,func,tol=0.01,maxIter=100, range=5):

#     return
#     await psfscan.run(fname,cmt,prefuncs)
#     print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")



# fleming.hta.fleming_measurement_test.els_flashlamp_align
async def els_flashlamp_align():
    # await myInitialization()
    # x0,y0 = await scantable_location(75.07,157.11)
    await scantable_96plate_location(1,1)
    # await fm.Move(0)
    l=13
    r=30

    l=197
    r=208

    n=(r-l)*50+1
    # n=(r-l)
    elsscan=AxisScan(els.Move,[l,r],n)
    
    psfscan=Scan([[elsscan]])
    # psfscan=Scan([[xscan],[yscan]])
    
    prefuncs=[[fms.Move,56.4],[get_all_mover_positions]]
    # prefuncs=[[abs_init,"1006"],[fm.Move,8.5],[fms.Move,56.4],[bld.Move,200.5]]
    # psfscan.functions([[psfscan.currentPos],[kaleido_abs,0.1,False]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    psfscan.functions([[psfscan.currentPos],[kaleido_abs,100,False]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    print(psfscan.dims)
    cmt = "lamp_els_full_scan"
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)


    await psfscan.run(fname,cmt,prefuncs)
    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")


# fleming.hta.fleming_measurement_test.els_photonDiode_alpha_align
async def els_photonDiode_alpha_align():
    # await myInitialization()
    # await scantable_location(75.38,156.885)
    
    await st.Home()
    # await fm.Move(0) 
    l=0
    r=360
    n=round((r-l))+1
    elsscan=AxisScan(els.Move,[l,r],n)
    elsscan=AxisScan(timeSeries,[l,r],n)
    
    elsscan=Scan([[elsscan]])
    # psfscan=Scan([[xscan],[yscan]])
    prefuncs=[[alpha_photo_init],[fm.Move,12.5],[apertures,0,0],[bld.Move,196]]
    # elsscan.functions([[elsscan.currentPos],[kaleido_alpha_photodiode]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    # elsscan.functions([[elsscan.currentPos],[kaleido_alpha]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    elsscan.functions([[elsscan.currentPos],[kaleido_alpha_photodiode]])  # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0

    cmt = inspect.stack()[0][3]
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)

    # await myalpha_on(0.75)
    await elsscan.run(fname,cmt,prefuncs)

    # await myalpha_off()
    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")


# fleming.hta.fleming_measurement_test.photonDiode_align
async def photonDiode_align():
    await myInitialization()
    await scantable_location(0,0)
    # await fm.Move(0) 
    l=0
    r=360
    n=round((r-l))
    axbld=AxisScan(bld.Move,[l,r],n)
    
    bldscan=Scan([[axbld]])
    # psfscan=Scan([[xscan],[yscan]])
    prefuncs=[[abs_init,"1006"],[fm.Move,12],[els.Move,248.19],[fms.Move,56.96]]
    # bldscan.functions([[bldscan.currentPos],[kaleido_abs,100,True]])  # true= switch off flashlam # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    bldscan.functions([[bldscan.currentPos],[kaleido_abs,100,False]])  # true= switch off flashlam # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0

    cmt = "bld_scan"
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    
    await bldscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")

# fleming.hta.fleming_measurement_test.fi_zscan
async def fi_zscan():
    await myInitialization()
    wellx=8
    welly=3
    await scantable_96plate_location(wellx,welly)

    l=0
    r=17.8
    n=round((r-l))
    axfm=AxisScan(fm.Move,[l,r],n)
    
    fmscan=Scan([[axfm]])
    # psfscan=Scan([[xscan],[yscan]])
    # prefuncs=[[FI_init,"1006"],[els.Move,204.015],[fms.Move,54.5],[bld.Move,242.15]]
    prefuncs=[[lum_init,"1006"],[els.Move,204.015],[bld.Move,242.15]]
    prefuncs=[]
    # bldscan.functions([[bldscan.currentPos],[kaleido_FI,0.1]])  # true= switch off flashlam # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0
    fmscan.functions([[fmscan.currentPos],[kaleido_lum,100]])  # true= switch off flashlam # measurementTime=100,  delay_us=200, windowTime_us=200, numberOfWindows=1, windowPauseTime_us=0

    cmt = inspect.stack()[0][3]
    timestamp=True
    fname=fnameGen(f"{instrument}_{cmt}",timestamp,prefuncs)
    
    await fmscan.run(fname,cmt,prefuncs)

    print(f"done!:\t{inspect.stack()[0][3]}\t{fname}")

# fleming.hta.fleming_measurement_test.procedure
async def procedure():
    # 1. rough els scan to find the positions
    # 2. 3d psfs to find the z focus
    # 3. els scan at each focus.
    # 4. double check 3d psfs again. (tune the scantable y position)
    # 5. detection psf find the focus.
    # 6. use the right focus and make 2D scan to tune the scan table x position
    # 7. tune the detection aperture.
    # 8. double check with FI.
    # good luck.
    
    roughExc=False
    if roughExc:
        await psf_exc_trfLaser(elsloc=248.4,z0=11,comment="")
        await psf_exc_alpha(elsloc=243.12,z0=12.5)
        await psf_exc_trfLaser(elsloc=248.85,z0=13.5)
    roughDet=False
    if roughDet:
        await psf_det_lum_pinhole()

    elsScan=True
    if elsScan:
        await els_photonDiode_trf_scan(z0=13.5)
        await els_photonDiode_alpha_scan(z0=13.5)
        await els_flashlamp_align(z0=12.5)
    
    excCheck=False
    if excCheck:
        await psf_exc_trfLaser(elsloc=248.4,z0=11,comment="")
        await psf_exc_alpha(elsloc=243.12,z0=12.5)
        await psf_exc_lamp(elsloc=248.85,z0=13.5)
    detectPSF=False
    if detectPSF: # 1:1
        await psf_det_lum_pinhole()
    
    overallPSF=False
    if overallPSF:
        await psf_exc_det_FI_measure()
        
    
    

async def psfScan(xr,xn,yr,yn,zr,zn,prefuncs,funcs):
    
    x0,y0=st.get_current_position()
    z0 = fm.getPosition()
    
    xscan=AxisScan(st_move_x,[-xr/2+x0,xr/2+x0],xn)
    yscan=AxisScan(st_move_y,[-yr/2+y0,yr/2+y0],yn)
    # psfscan=Scan([[xscan],[yscan]])
    zscan=AxisScan(fm.Move,[z0-zr/2,z0+zr/2],zn)
    psf=Scan([[xscan],[yscan],[zscan]])

async def timeSeries(*args):
    pass

async def close():
    # await myInitialization()
    # await scan_table.Home()
    # await fms.Move(0)
    pd = VUnits.instance.hal.plateDoor
    await pd.UseProfile(1)    
    await pd.Close()
    return
async def open():
    # await myInitialization()
    # await scan_table.Home()
    # await fms.Move(0)
    pd = VUnits.instance.hal.plateDoor
    await pd.UseProfile(1)    
    await pd.Open()
    return


# async def eject():
#     await eject()    

# async def load():
#     await load()    


# fleming.hta.fleming_measurement_test.temp
async def temp():
    await myInitialization()
    # await eject()
    await load()
    # await scan_table.Home()
    # await fms.Move(0)
    # pd = VUnits.instance.hal.plateDoor
    # await pd.UseProfile(1)    
    # await pd.Open()
    # await pd.Home()
    # a=await els.Home()
    # print(a,type(a))
    # await load()
    # await st.Home()
    await fms.Home()
    return
    await els.Home()
    if False:
        await els.Move(248.7)
        
        await fms.Move(55.4+24*2)
        await st.Home()
        # await fms.Move(0)
        # return
        await fm.Move(0)
        # await alpha_init()
        # for i in range(1):
        re=await kaleido_trf_laser_photodiode(10000)
        print(re)
    # await alpha_photo_init()
    await els.Move(243.14)
    for i in range(200):
        re=await kaleido_alpha_photodiode(0.001)
        # await els.Move(23.14)
        # re=await kaleido_abs(200,False)
        print(re)
    # # await scantable_96plate_location(1,1)
    
    
    # return
    # # await pd.Open()
    # await eject()
    # # await load()
    # await fm.Move(17)
    # await lum_init(1006)
    pos=await get_all_mover_positions()
    pos['els_pos']+=1.0
    await set_all_mover_positions(pos)

    
    re =await kaleido_lum(1000)
    print(re)
    return

    prefuncs=[[els.Move,248.22],[bld.Move,0.5],[fms.Move,54.5]] # ,[apertures,0,0]] # Hamburg pilot lase testing script
    # prefuncs=[[els.Move,248.22],[bld.Move,200.5],[fms.Move,0]] # ,[apertures,0,0]] # Hamburg pilot lase testing script
    # await header_output_Gen(prefuncs)
    # return
    # for i in linspace(54,57,20):
    #     print(i)
    #     await fms.Move(i)
    #     input("Press Enter to continue...")

    input("Press Enter to continue...")
    for i in linspace(0,17,17):
        print(i)
        await fm.Move(i)
        await sleep(0.5)
    wellx=11
    welly=6

    # await scantable_96plate_location(wellx,welly)
    # st=st = VUnits.instance.hal.scan_table
    # await st.MoveToWell(1,1)
    # imp.reload(scantable_384plate_location)
    # await scantable_384plate_location(wellx,welly)

    # await fm.Move(15)
    # await eject()
    # return
    # await das1.Home()
    # await das1.Move(12.6)
    # await set_dl(0.27,0.27)
    # await set_hv(0.45,0.45)

    # await das1.Move(0)
    # for i in linspace(0,20,20):
    # for i in linspace(0,100,2):
    #     print(i)
    #     # await das1.Move(i)
    #     out=await kaleido_abs(1000,True) # (0.001,200,50,1,5)
    #     print(out)


    # await apertures(0,0)

